<?php

namespace App\Http\Controllers;

use App\Models\Blog;
use App\Models\Category;

use Illuminate\Http\Request;

class BlogController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $page_title="All Blogs";
        $data=Blog::orderBy('id','DESC')->paginate(10);
        return view('backend.sadmin.blogs.index',compact('page_title','data'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $page_title='Blog Create';
        $category=Category::where('status',1)->get();

        return view('backend.sadmin.blogs.create',compact('page_title','category'))->with('language_option', $this->language_option);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request,Blog $blogs)
    {
        $data=$request->all();
        if ($request->hasFile('image')) {
            $file = $request->file('image');
            $image = $this->upload_single_image($file, $folder = 'blogs');
            $data['image'] = $folder."/".$image;
        }
        if(empty($request->slug))
        {
            $data['slug']=$this->slugCreate($request->title);
        }
        else{
            $data['slug']=$request->slug;
        } 

        $blogs->create($data);
        return redirect()->route('blog.index')->with('message', 'Blog added successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(Blog $blog)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Blog $blog)
    {
        $page_title="Edit Blog";
        $pcategory=Category::where('status',1)->get();

        return view('backend.sadmin.blogs.update',compact('page_title','blog','pcategory'))->with('language_option', $this->language_option);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Blog $blog)
    {
        $data=$request->all();
        if(empty($request->slug))
                {
                    $data['slug']=$this->slugCreate($request->title);
                }
                else{
                    $data['slug']=$request->slug;
                } 
                if ($request->hasFile('image')) {
                    $file = $request->file('image');
                    $image = $this->upload_single_image($file, $folder = 'course');
                    $data['image'] = $folder."/".$image;
                }
        $blog->update($data);
        return redirect(route('blog.index'))->with('message','Blog Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Blog $blog)
    {
        if($blog->delete())
        {
            $response = array('success' => true, 'error' => false, 'message' => 'Data Delete successfully..');
        }
    else{
        $response = array('success' => false, 'error' => true, 'message' => 'Something Went Wrong !');
         }
    return $response;
    }
    
}
