<?php

namespace App\Http\Controllers;

use App\Models\Course;
use App\Models\Category;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;

class CourseController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $page_title="All Courses";
        $data=Course::orderBy('id','DESC')->paginate(10);
        return view('backend.sadmin.courses.index',compact('page_title','data'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $page_title='Course Create';
        $category=Category::where('status',1)->get();
        return view('backend.sadmin.courses.create',compact('page_title','category'))->with('language_option', $this->language_option);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request,Course $course)
    {
        $data=$request->all();
        if ($request->hasFile('course_media')) {
            $file = $request->file('course_media');
            $image = $this->upload_single_image($file, $folder = 'course');
            $data['course_media'] = $folder."/".$image;
        }
        if(empty($request->course_slug))
        {
            $data['course_slug']=$this->slugCreate($request->course_title);
        }
        else{
            $data['course_slug']=$request->course_slug;
        } 
        $course->create($data);
        return redirect()->route('courses.index')->with('message', 'Courses added successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(Course $course)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Course $course)
    {
        $page_title="Edit Course";
        $pcategory=Category::where('status',1)->get();
        return view('backend.sadmin.courses.update',compact('page_title','course','pcategory'))->with('language_option', $this->language_option);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Course $course)
    {
        $data=$request->all();
            if(empty($request->course_slug))
                {
                    $data['course_slug']=$this->slugCreate($request->name);
                }
                else{
                    $data['course_slug']=$request->course_slug;
                } 
                if ($request->hasFile('course_media')) {
                    $file = $request->file('course_media');
                    $image = $this->upload_single_image($file, $folder = 'course');
                    $data['course_media'] = $folder."/".$image;
                }
        $course->update($data);
        return redirect(route('courses.index'))->with('message','Course Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Course $course)
    {
        if($course->delete())
        {
            $response = array('success' => true, 'error' => false, 'message' => 'Data Delete successfully..');
        }
    else{
        $response = array('success' => false, 'error' => true, 'message' => 'Something Went Wrong !');
         }
    return $response;
    }
    
}
