<?php

namespace App\Http\Controllers;

use App\Models\Department;
use Illuminate\Http\Request;

class DepartmentController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $page_title="All Department";
        $data=Department::orderBy('id','DESC')->paginate(10);
        return view('backend.sadmin.departments.index',compact('page_title','data'));
 
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $page_title='Department Create';
       
        return view('backend.sadmin.departments.create',compact('page_title'))->with('language_option', $this->language_option);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request,Department $department)
    {
        $data=$request->all();
         
        $department->create($data);
        return redirect()->route('departments.index')->with('message', 'Courses added successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(Department $department)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Department $department)
    {
        $page_title="Edit Department";
        return view('backend.sadmin.departments.update',compact('page_title','department'))->with('language_option', $this->language_option);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Department $department)
    {
        $data=$request->all();
            
        $department->update($data);
        return redirect(route('departments.index'))->with('message','Departments Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Department $department)
    {
        if($department->delete())
        {
            $response = array('success' => true, 'error' => false, 'message' => 'Data Delete successfully..');
        }
    else{
        $response = array('success' => false, 'error' => true, 'message' => 'Something Went Wrong !');
         }
    return $response;
    }
}
