<?php

namespace App\Http\Controllers;

use App\Models\Event;
use Illuminate\Http\Request;

class EventController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $page_title="All Events";
        $data=Event::orderBy('id','DESC')->paginate(10);
        return view('backend.sadmin.events.index',compact('page_title','data'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $page_title='Event Create';
        return view('backend.sadmin.events.create',compact('page_title'))->with('language_option', $this->language_option);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request,Event $event)
    {
        $data=$request->all();
        if ($request->hasFile('image')) {
            $file = $request->file('image');
            $image = $this->upload_single_image($file, $folder = 'events');
            $data['image'] = $folder."/".$image;
        }

        $event->create($data);
        return redirect()->route('events.index')->with('message', 'Events added successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(Event $event)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Event $event)
    {
        $page_title="Edit Event";
        return view('backend.sadmin.events.update',compact('page_title','event'))->with('language_option', $this->language_option);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Event $event)
    {
        $data=$request->all();
        if ($request->hasFile('image')) {
            $file = $request->file('image');
            $image = $this->upload_single_image($file, $folder = 'events');
            $data['image'] = $folder."/".$image;
        }
        $event->update($data);
        return redirect(route('events.index'))->with('message','Events Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Event $event)
    {
        if($event->delete())
        {
            $response = array('success' => true, 'error' => false, 'message' => 'Data Delete successfully..');
        }
    else{
        $response = array('success' => false, 'error' => true, 'message' => 'Something Went Wrong !');
         }
    return $response;
    }
}
