<?php

namespace App\Http\Controllers;

use App\Models\Holidays;
use App\Models\Department;
use Illuminate\Http\Request;

class HolidaysController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $page_title="All Holidays";
        $data=Holidays::orderBy('id','DESC')->paginate(10);
        return view('backend.sadmin.holidays.index',compact('page_title','data'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $page_title='Holidays Create';
        $department=Department::where('status',1)->get();
        return view('backend.sadmin.holidays.create',compact('page_title','department'))->with('language_option', $this->language_option);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request,Holidays $holidays)
    {
        $data=$request->all();
       
        $holidays->create($data);
        return redirect()->route('holidays.index')->with('message', 'Holidays added successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(Holidays $holidays)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Holidays $holidays,$id)
    {
       $holidays= Holidays::find($id);
        $page_title="Edit Holidays";
        $department=Department::where('status',1)->get();
        return view('backend.sadmin.holidays.update',compact('page_title','holidays','department'))->with('language_option', $this->language_option);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Holidays $holidays)
    {
        $holidays=Holidays::find($request->id);
        $data=$request->all();

        $holidays->update($data);
        return redirect(route('holidays.index'))->with('message','Holidays Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Holidays $holidays)
    {
        if($holidays->delete())
        {
            $response = array('success' => true, 'error' => false, 'message' => 'Data Delete successfully..');
        }
    else{
        $response = array('success' => false, 'error' => true, 'message' => 'Something Went Wrong !');
         }
    return $response;
    }
}
