<?php

namespace App\Http\Controllers;

use App\Models\ProfileSettings;
use App\Models\User;
use Illuminate\Http\Request;
use Session;
use Auth;

class ProfileSettingsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(ProfileSettings $profileSettings)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(ProfileSettings $profileSettings,$id)
    {
       $result  = ProfileSettings::where('user_id', $id)->first();
       if($result['fname']==null)
       {
        $user = User::find($id);
        $result['fname']=$user['name'];
       }
        $page_title="Update Profile Information";
        $country=$this->country;
        $language=$this->language_option;
        return view('student.profile.edit',compact('page_title','result','country','language'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, ProfileSettings $profileSettings)
    {
        $data = $request->all();
        $profileSettings=ProfileSettings::find($request->id);
        $userdata = User::find($request->user_id);
        
        $fullname=$request->fname." ".$request->lname;
        $updateprofile=['name'=>$fullname];

    
        if ($request->hasFile('image')) {
            $file = $request->file('image');
            $image = $this->upload_single_image($file, $folder = 'profile');
            $data['image'] = $folder . "/" . $image;
        }
    
        $result = $profileSettings->update($data);
        $userdata->update(['name'=>$fullname]);
    
        if (Session::get('user_type') == 'student') {
            return redirect(route('profile.edit',Auth::user('users')->id))->with('message', 'Profile Updated Successfully');
        } else {
            return redirect(route('profile.index'))->with('message', 'Profile Updated Successfully');
        }
        
    }
    

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(ProfileSettings $profileSettings)
    {
        //
    }
}
