<?php

namespace App\Http\Controllers;

use App\Models\Student;
use App\Models\Course;
use Illuminate\Http\Request;

class StudentController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $page_title="All Student";
        $data=Student::orderBy('id','DESC')->paginate(10);
        return view('backend.sadmin.students.index',compact('page_title','data'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $page_title='Student Create';
        $course=Course::where('status',1)->get();
        $country=$this->country;
        $language=$this->language_option;
        return view('backend.sadmin.students.create',compact('page_title','course','country','language'))->with('language_option', $this->language_option);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request,Student $student)
    {
        {
            $data=$request->all();
            if ($request->hasFile('image')) {
                $file = $request->file('image');
                $image = $this->upload_single_image($file, $folder = 'student');
                $data['image'] = $folder."/".$image;
            }
            
            $student->create($data);
            return redirect()->route('students.index')->with('message', 'Student added successfully');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Student $student)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Student $student)
    {
        $page_title="Edit Student";
        $course=Course::where('status',1)->get();
        $country=$this->country;
        $language=$this->language_option;
        return view('backend.sadmin.students.update',compact('page_title','student','course','country','language'))->with('language_option', $this->language_option);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Student $student)
    {
        $data=$request->all();
        
            if ($request->hasFile('image')) {
                $file = $request->file('image');
                $image = $this->upload_single_image($file, $folder = 'student');
                $data['image'] = $folder."/".$image;
            }
    $student->update($data);
    return redirect(route('students.index'))->with('message','Student Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Student $student)
    {
        if($student->delete())
        {
            $response = array('success' => true, 'error' => false, 'message' => 'Data Delete successfully..');
        }
    else{
        $response = array('success' => false, 'error' => true, 'message' => 'Something Went Wrong !');
         }
    return $response;
    }
}
