<?php

namespace App\Http\Controllers;

use App\Models\Teacher;
use App\Models\User;
use App\Mail\TeacherMail;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Mail;
use Auth;
use Session;

class TeacherController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $page_title="All Teachers";
        $data=Teacher::orderBy('id','DESC')->paginate(10);
        return view('backend.sadmin.teachers.index',compact('page_title','data'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $page_title='Teacher Create';
        return view('backend.sadmin.teachers.create',compact('page_title'))->with('language_option', $this->language_option);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, Teacher $teacher, User $user)
    {

        $otp = rand(10000000, 99999999);
        $password = Hash::make($otp);
        $teacher_login_data=['name'=>$request->name,'email'=>$request->email,'user_type'=>$request->user_type,'password'=>$password,'status'=>1];
        $teacher_login_result=$user->create($teacher_login_data);
        $login_id = $teacher_login_result->id;
        if($teacher_login_result)
        {
        $data=$request->all();
        if ($request->hasFile('image')) {
            $file = $request->file('image');
            $image = $this->upload_single_image($file, $folder = 'teachers');
            $data['image'] = $folder."/".$image;
        }
        // $teacher->create($data);
        $data['login_id']=$login_id;
            $teacher->create($data);
            $mail_data=['otp'=>$otp,'email'=>$request->email,'name'=>$request->name];
            Mail::to($request->email)->send(new TeacherMail($mail_data));
        return redirect()->route('teachers.index')->with('message', 'Teacher added successfully');
    }
}

    /**
     * Display the specified resource.
     */
    public function show(Teacher $teacher)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Teacher $teacher)
    {
        $page_title="Edit Teacher";
        return view('backend.sadmin.teachers.update',compact('page_title','teacher'))->with('language_option', $this->language_option);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Teacher $teacher)
    {
        $data=$request->all();
        if(empty($request->slug))
                {
                    $data['slug']=$this->slugCreate($request->name);
                }
                else{
                    $data['slug']=$request->slug;
                } 
                if ($request->hasFile('image')) {
                    $file = $request->file('image');
                    $image = $this->upload_single_image($file, $folder = 'course');
                    $data['image'] = $folder."/".$image;
                }
        $teacher->update($data);
        return redirect(route('teachers.index'))->with('message','Teacher Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Teacher $teacher)
    {
        if($teacher->delete())
        {
            $response = array('success' => true, 'error' => false, 'message' => 'Data Delete successfully..');
        }
    else{
        $response = array('success' => false, 'error' => true, 'message' => 'Something Went Wrong !');
         }
    return $response;
    }
    
}
