<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('courses', function (Blueprint $table) {
            $table->id();
            $table->string('course_title')->nullable();
            $table->string('course_slug')->nullable();
            $table->string('course_language')->nullable();
            $table->string('course_media')->nullable();
            $table->integer('course_category')->nullable();
            $table->longText('course_description')->nullable();
            $table->longText('course_curriculum')->nullable();
            $table->longText('course_advisior')->nullable();
            $table->integer('course_lecture')->default(0);
            $table->string('course_duration')->nullable();
            $table->string('course_skill_level')->nullable();
            $table->float('price', 8, 2)->nullable();
            $table->float('after_discount', 8, 2)->nullable();
            $table->string('course_metatitle')->nullable();
            $table->mediumText('course_meta_description')->nullable();
            $table->mediumText('course_meta_keyword')->nullable();
            $table->tinyInteger('status')->default(0);


            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('courses');
    }
};
