<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('profile_settings', function (Blueprint $table) {
            $table->id();
            $table->string('fname')->nullable();
            $table->string('lname')->nullable();
            $table->string('description_bio')->nullable();
            $table->string('country')->nullable();
            $table->string('phone')->nullable();
            $table->string('address')->nullable();
            $table->string('subscribe_to_newsletter')->nullable();

            $table->string('image')->nullable();
            $table->string('description')->nullable();
            $table->string('social_link_1')->nullable();
            $table->string('social_link_2')->nullable();
            $table->string('social_link_3')->nullable();
            $table->tinyInteger('deleted_by')->default(0);
            $table->tinyInteger('is_deleted')->default(0);
            $table->integer('user_id')->nullable();
            $table->tinyInteger('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('profile_settings');
    }
};
