<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Auth;
use Session;
use App\Models\User;
use App\Models\Student;
use App\Mail\StudentEmailVerify;
use App\Mail\ResetPasswordMail;
use Mail;

class AuthController extends Controller
{
    public function login(Request $request){
        if(Auth::check())
        {
            return redirect(route('admin_dashboard'));
        }
        else{

            return view('backend.auth.login');
        }
    }

    public function AuthLogin(Request $request){
    
        $this->validate($request, [
            'email'   => 'required|email',
            'password'  => 'required|min:8',
            'user_type'=>'required'
        ]);
    
        $credentials = $request->only('email', 'password');
        $credentials['user_type'] = $request->input('user_type');
    
        if(Auth::attempt($credentials))
        {
            $request->session()->put('user_type',Auth::user()->user_type);
            if(Auth::user()->user_type=='admin')
            {

                return redirect(route('admin_dashboard'));
            }
            if(Auth::user()->user_type=='student')
            {
                return redirect(route('student_dashboard'));
            }
            if(Auth::user()->user_type=='hr')
            {
                return redirect(route('hr_dashboard'));
            }
            if(Auth::user()->user_type=='super_admin')
            {
                return redirect(route('super_admin_dashboard'));
            }
            if(Auth::user()->user_type=='mentor')
            {
                return redirect(route('mentor_dashboard'));
            }
        }
        else {
            return redirect()->back()->withInput($request->only('email', 'user_type'))->withErrors([
                'password' => 'Invalid email or password.',
            ]);
        }
    }
    

    

    public function signup(Request $request){
        return view('backend.auth.signup');
    }

    public function login_message(Request $request){
        return view('message');
    }

    
    public function signupStore(Request $request,User $user,Student $student){
        if($request->password == $request->cpassword) 
        {
            
            $token = base64_encode(random_bytes(32)); 
            $data=$request->all();
            $password = Hash::make($request->password);
            $data['password']=$password;
            $data['status']=0;
            $data['remember_token']=$token;
            $result=$user->create($data);
            $profile_create=['student_name'=>$request->name,'email'=>$request->email,'user_id'=>$result->id];
            $result2=$student->create($profile_create);

            if($result && $result2)
            {
                Mail::to($request->email)->send(new StudentEmailVerify($result));
                return redirect(route('login_message'));
            }
        }
        else{
            return view('backend.auth.signup')->with('error','Check Details');
        }
    }


    public function forget(Request $request){
        return view('forgot_password');
    }
    public function otpview(Request $request){
        return view('otp');
    }
    public function reset_password(Request $request,$token){
        return view('reset_password',compact('token'));
    }



    
    
    public function forget_post(Request $request, User $user) {
        $date = User::where('email', $request->email)
                     ->where('user_type', $request->user_type)
                     ->first(); 
    
        if ($date) {
            $token = base64_encode(random_bytes(32)); // Generate token
    
            // Update user with new token
            $date->update(['remember_token' => $token]);
    
            // Send email with verification link
            Mail::to($date->email)->send(new ResetPasswordMail($date));
    
            return view('forgot_password',compact('token')); // Assuming you want to show an OTP verification page
        } else {
            return view('forgot_password')->with('message', 'This email is not registered');
        }
    }

    public function password_update(Request $request, User $user) {
        $date = User::where('remember_token', $request->remember_token)
                     ->first(); 
            $password = Hash::make($request->password);
            $formattedDate = date('Y-m-d H:i:s', time());
            $result=$date->update(['password' => $password,'remember_token'=>'','email_verified_at'=>$formattedDate]);

        if($result)
        {
            $user_type=$data->user_type;
            return view('reset_password',compact('user_type')); // Assuming you want to show an OTP verification page
        } else {
            return view('forgot_password')->with('error', 'Password is not match!');
        }
    }

    public function VerifyEmail(Request $request){
        $date = User::where('remember_token', $token)
        ->first(); 
        $result=$date->update(['remember_token'=>'','email_verified_at'=>$formattedDate]);
        return view('reset_password',compact('token'));
    }


    public function userlogout(Request $request){
        
        Auth::guard('web')->logout();

        $request->session()->invalidate();
        $request->session()->regenerateToken();

            $request->session()->pull('user_type');
            return redirect(route('login'));
               
    }
    public function terms(Request $request){
      
            return view('backend.terms');      
    }


    public function studentLogin(){
        return view('login');      
    }

    public function studentRegistration(){
        return view('register');    
    }
}
