<?php

namespace App\Http\Controllers;

use App\Models\Category;
use Illuminate\Http\Request;
use Session;
class CategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $page_title="All Category";
        $data=Category::orderBy('id','DESC')->paginate(10);

        //  For Route Redirection
        $user_type=Session::get('user_type');
        if($this->user_type()=='super_admin')
        {
        return view('backend.sadmin.courses_category.index',compact('page_title','data'));
        }
        if($user_type=='admin')
        {
            return view('backend.admin.courses_category.index',compact('page_title','data'));
        }
        else
        {
            return view('backend.hr.courses_category.index',compact('page_title','data'));
        }
        
        
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $page_title="Add Category";
        $category=Category::where('status',1)->get();
        return view('backend.sadmin.courses_category.create',compact('page_title','category'))->with('language_option', $this->language_option);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, Category $category)
    {
        // Extract all data from the request
        $data = $request->all();
    
        // If slug is not provided in the request, create one
        if (empty($data['slug'])) {
            $data['slug'] = $this->slugCreate($data['name']);
        }
    
        // If an image file is uploaded, handle it
        if ($request->hasFile('image')) {
            $file = $request->file('image');
            $image = $this->upload_single_image($file, $folder = 'categories');
            $data['image'] = $folder."/".$image;
        }
    
        // Create a new category with the provided data
        $category->create($data);
    
        // Redirect back to the index page with a success message
        
        return redirect()->route('category.index')->with('message', 'Category added successfully');
    }
    

    /**
     * Display the specified resource.
     */
    public function show(Category $category)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Category $category)
    {
        $page_title="Edit Category";
        $pcategory=Category::where('status',1)->get();
        return view('backend.sadmin.courses_category.update',compact('page_title','category','pcategory'))->with('language_option', $this->language_option);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Category $category)
    {
        $data=$request->all();
        if(empty($request->slug))
                {
                    $data['slug']=$this->slugCreate($request->name);
                }
                else{
                    $data['slug']=$request->slug;
                } 
                if ($request->hasFile('image')) {
                    $file = $request->file('image');
                    $image = $this->upload_single_image($file, $folder = 'categories');
                    $data['image'] = $folder."/".$image;
                }
        $category->update($data);
        return redirect(route('category.index'))->with('message','Category Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Category $category)
    {
        if($category->delete())
        {
            $response = array('success' => true, 'error' => false, 'message' => 'Data Delete successfully..');
        }
    else{
        $response = array('success' => false, 'error' => true, 'message' => 'Something Went Wrong !');
         }
    return $response;
    }
}
