<?php

namespace App\Http\Controllers;

use App\Models\Mentor;
use App\Models\User;
use App\Mail\MentorMail;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Mail;
use Auth;
use Session;
class MentorController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $page_title="All Mentors";
        $data=Mentor::orderBy('id','DESC')->paginate(10);
        return view('backend.sadmin.mentors.index',compact('page_title','data'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $page_title='Mentor Create';
        return view('backend.sadmin.mentors.create',compact('page_title'))->with('language_option', $this->language_option);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, Mentor $mentor, User $user)
    {
        //  Auth Creation for Login
        $otp = rand(10000000, 99999999);
        $password = Hash::make($otp);
        $mentor_login_data=['name'=>$request->name,'email'=>$request->email,'user_type'=>$request->user_type,'password'=>$password];
        
        $mentor_login_result=$user->create($mentor_login_data);
        $login_id = $mentor_login_result->id;
        if($mentor_login_result)
        {
            $data=$request->all();
            if ($request->hasFile('image')) {
                $file = $request->file('image');
                $image = $this->upload_single_image($file, $folder = 'mentor');
                $data['image'] = $folder."/".$image;
            }
            $data['login_id']=$login_id;
            $mentor->create($data);
            $mail_data=['otp'=>$otp,'email'=>$request->email,'name'=>$request->name];
            Mail::to($request->email)->send(new MentorMail($mail_data));

            return redirect()->route('mentor.index')->with('message', 'Mentor added successfully');

        }

      
    }

    /**
     * Display the specified resource.
     */
    public function show(Mentor $mentor)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Mentor $mentor)
    {
        $page_title="Edit Mentor";
        return view('backend.sadmin.mentors.update',compact('page_title','mentor'))->with('language_option', $this->language_option);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Mentor $mentor)
    {
        $data=$request->all();
        if(empty($request->slug))
                {
                    $data['slug']=$this->slugCreate($request->name);
                }
                else{
                    $data['slug']=$request->slug;
                } 
                if ($request->hasFile('image')) {
                    $file = $request->file('image');
                    $image = $this->upload_single_image($file, $folder = 'course');
                    $data['image'] = $folder."/".$image;
                }
        $mentor->update($data);
        return redirect(route('mentor.index'))->with('message','Mentor Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Mentor $mentor)
    {
        if($mentor->delete())
        {
            $response = array('success' => true, 'error' => false, 'message' => 'Data Delete successfully..');
        }
    else{
        $response = array('success' => false, 'error' => true, 'message' => 'Something Went Wrong !');
         }
    return $response;
    }
}
