<?php

namespace App\Http\Controllers;

use App\Models\Notice;
use Illuminate\Http\Request;

class NoticeController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $page_title="All Notices";
        $data=Notice::orderBy('id','DESC')->paginate(10);
        return view('backend.sadmin.notices.index',compact('page_title','data'));   
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $page_title='Notice Create';
        return view('backend.sadmin.notices.create',compact('page_title'))->with('language_option', $this->language_option);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request,Notice $notice)
    {
        $data=$request->all();
        
        $notice->create($data);
        return redirect()->route('notices.index')->with('message', 'Notices added successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(Notice $notice)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Notice $notice)
    {
        $page_title="Edit Notices";
        return view('backend.sadmin.notices.update',compact('page_title','notice'))->with('language_option', $this->language_option);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Notice $notice)
    {
        $data=$request->all();
            
        $notice->update($data);
        return redirect(route('notices.index'))->with('message','Notices Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Notice $notice)
    {
        if($notice->delete())
        {
            $response = array('success' => true, 'error' => false, 'message' => 'Data Delete successfully..');
        }
    else{
        $response = array('success' => false, 'error' => true, 'message' => 'Something Went Wrong !');
         }
    return $response;
    }
}
