<?php

namespace App\Http\Controllers;

use App\Models\Teacher;
use Illuminate\Http\Request;

class TeacherController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $page_title="All Teachers";
        $data=Teacher::orderBy('id','DESC')->paginate(10);
        return view('backend.sadmin.teachers.index',compact('page_title','data'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $page_title='Teacher Create';
        return view('backend.sadmin.teachers.create',compact('page_title'))->with('language_option', $this->language_option);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, Teacher $teacher)
    {
        $data=$request->all();
        if ($request->hasFile('image')) {
            $file = $request->file('image');
            $image = $this->upload_single_image($file, $folder = 'teachers');
            $data['image'] = $folder."/".$image;
        }
        $teacher->create($data);
        return redirect()->route('teachers.index')->with('message', 'Teacher added successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(Teacher $teacher)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Teacher $teacher)
    {
        $page_title="Edit Teacher";
        return view('backend.sadmin.teachers.update',compact('page_title','teacher'))->with('language_option', $this->language_option);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Teacher $teacher)
    {
        $data=$request->all();
        if(empty($request->slug))
                {
                    $data['slug']=$this->slugCreate($request->name);
                }
                else{
                    $data['slug']=$request->slug;
                } 
                if ($request->hasFile('image')) {
                    $file = $request->file('image');
                    $image = $this->upload_single_image($file, $folder = 'course');
                    $data['image'] = $folder."/".$image;
                }
        $teacher->update($data);
        return redirect(route('teachers.index'))->with('message','Teacher Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Teacher $teacher)
    {
        if($teacher->delete())
        {
            $response = array('success' => true, 'error' => false, 'message' => 'Data Delete successfully..');
        }
    else{
        $response = array('success' => false, 'error' => true, 'message' => 'Something Went Wrong !');
         }
    return $response;
    }
    
}
