<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('students', function (Blueprint $table) {
            $table->id();
            $table->string('reg_no')->nullable();
            $table->integer('batch_id')->nullable();
            $table->string('student_name')->nullable();
            $table->string('student_address')->nullable();
            $table->string('phone')->nullable();
            $table->string('dob')->nullable();
            $table->string('email')->nullable();
            $table->string('father_name')->nullable();
            $table->string('father_phone')->nullable();
            $table->string('mother_name')->nullable();
            $table->string('mother_phone')->nullable();
            $table->string('resident_phone')->nullable();
            $table->string('resident_address')->nullable();
            $table->string('admission_date')->nullable();
            $table->string('admitted_by')->nullable();
            $table->string('image')->nullable();
            $table->string('enroll_programme')->nullable();
            $table->tinyInteger('deleted_by')->default(0);
            $table->tinyInteger('status')->default(1);
            $table->tinyInteger('is_deleted')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('students');
    }
};
