<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('blogs', function (Blueprint $table) {
            $table->id();
            $table->string('title')->nullable();
            $table->string('slug')->nullable();
            $table->string('image')->nullable();
            $table->mediumtext('description')->nullable();
            $table->string('image_url')->nullable();
            $table->string('tags')->nullable();
            $table->integer('cat_id')->nullable();
            $table->integer('total_view')->nullable();
            $table->string('written_by')->nullable();
            $table->tinyInteger('deleted_by')->default(0);
            $table->tinyInteger('is_deleted')->default(0);
            $table->tinyInteger('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('blogs');
    }
};
