<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('categories', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->string('language')->nullable();
            $table->string('slug')->nullable();
            $table->string('image')->nullable();
            $table->string('image_code')->nullable();
            $table->integer('parent_category')->default(0);
            $table->tinyInteger('status')->default(0);
            $table->string('course_metatitle')->nullable();
            $table->mediumText('course_meta_description')->nullable();
            $table->mediumText('course_meta_keyword')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('categories');
    }
};
