@extends('layouts.Master')
@section('page')
<div class="mdk-header-layout__content mdk-header-layout__content--fullbleed mdk-header-layout__content--scrollable page" style="padding-top: 60px;">


    <div class="page__heading border-bottom">
        <div class="container-fluid page__container d-flex align-items-center">
            <h1 class="mb-0">{{$page_title}}</h1>
            <a href="{{route('courses.create')}}" class="btn btn-success ml-auto"><i class="material-icons">add</i> New Course</a>
        </div>
    </div>

    <div class="container-fluid page__container">

        <form action="#" class="mb-3 border-bottom pb-3">
            <div class="d-flex">
                <div class="search-form mr-3 search-form--light">
                    <input type="text" class="form-control" placeholder="Search courses" id="searchSample02">
                    <button class="btn" type="button"><i class="material-icons">search</i></button>
                </div>

                <div class="form-inline ml-auto">
                    <div class="form-group mr-3">
                        <label for="custom-select" class="form-label mr-1">Category</label>
                        <select id="custom-select" class="form-control custom-select" style="width: 200px;">
                            <option selected>All categories</option>
                            <option value="1">Vue.js</option>
                            <option value="2">Node.js</option>
                            <option value="3">GitHub</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="published01" class="form-label mr-1">Published</label>
                        <select id="published01" class="form-control custom-select" style="width: 200px;">
                            <option selected>Published</option>
                            <option value="1">Draft</option>
                            <option value="3">All</option>
                        </select>
                    </div>
                </div>
            </div>
        </form>



        <div class="row">
            @if($data)
            @foreach($data as $key=>$value)
            <div class="col-md-6">
                <div class="card">
                    <div class="card-body">

                        <div class="d-flex flex-column flex-sm-row">
                            <a href="#" class="avatar mb-3 w-xs-plus-down-100 mr-sm-3">
                                <img src="{{url('/images/'.$value->course_media)}}" alt="Card image cap" class="avatar-course-img">
                            </a>
                            <div class="flex" style="min-width: 200px;">
                                <div class="d-flex">
                                    <div>
                                        <h4 class="card-title mb-1"><a href="{{route('courses.edit',$value->id)}}">{{$value->course_title}}</a></h4>
                                        <p class="text-muted">{{Str::limit($value->course_description, $limit = 100, $end = '...') }}</p>
                                    </div>
                                    <div class="dropdown ml-auto">
                                        <a href="#" class="dropdown-toggle text-muted" data-caret="false" data-toggle="dropdown">
                                            <i class="material-icons">more_vert</i>
                                        </a>
                                        <div class="dropdown-menu dropdown-menu-right">
                                            <a class="dropdown-item" href="{{route('courses.edit',$value->id)}}">Edit Course</a>
                                            <div class="dropdown-divider"></div>
                                            <a href="javascript:void(0);" onclick="deleteData({{$value->id}})" class="dropdown-item text-danger"><i class="bx bx-trash-alt"></i> Delete</a>
                                        </div>
                                    </div>
                                </div>
                                <div class="d-flex align-items-end">
                                    <div class="d-flex flex flex-column mr-3">
                                        <div class="d-flex align-items-center py-2 border-bottom">
                                            <span class="mr-2">&dollar;{{$value->price}}</span>
                                            <small class="text-muted ml-auto">34 SALES</small>
                                        </div>
                                        <div class="d-flex align-items-center py-2">
                                            @if($value->status == 1)
                                            <div class="badge badge-soft-vuejs badge-pill mr-3">Published</div>
                                            @else
                                            <div class="badge badge-soft-angular badge-pill mr-3">Draft</div>
                                            @endif
                                        </div>
                                     
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
            @endforeach
            @endif

        </div>

    </div>
</div>

@endsection

@push('script')
<script>
    function deleteData(tid){
        if(confirm('Are You sure'))
        {
        $.ajax({
            method:'DELETE',
            url: '{{ url('admin/courses/') }}/'+tid,
            data:{
                id: tid,
                _token: '{{ csrf_token() }}'
            },
            success:function(response){
                
                if(response.success)
                {
                    swal("Deleted!", "Data Deleted Successfully!", "error");
                    setTimeout(function() {
                        window.location.reload();
                    }, 3000);

                }
                
            }
        });
    }
}
    </script>
@endpush