@extends('layouts.Master')

@section('page')
 <!-- Header Layout Content -->
 <div class="mdk-header-layout__content mdk-header-layout__content--fullbleed mdk-header-layout__content--scrollable page" style="padding-top: 60px;">


    <div class="page__heading border-bottom">
        <div class="container-fluid page__container">
            <h2>{{$page_title}}</h2>
            
        </div>
        <div class="card card-form">
            <form method="post" action="{{route('category.update',$category->id)}}" enctype="multipart/form-data" id="form-validation">
                @method('PUT')
                @csrf
                    <div class="card">
                                 
                        <div class="card-body">
                            <div class="mb-3 row">
                                <label for="answer-0" class="col-md-2 col-form-label">Select Language</label>
                                <div class="col-md-10">
                                    <select class="form-control" name="language">
                                        @foreach($language_option as $key=>$value)
                                        <option value="{{$key}}" {{$key==$category->language?'selected':''}}>{{$value}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="faq">
                                <div class="mb-3 row">
                                    <label for="question-0" class="col-md-2 col-form-label">Categories Name<span class="text-danger">*</span></label>
                                    <div class="col-md-10">
                                        <input class="form-control" type="text" findex="1"  name="name" placeholder="Enter Categories Name" id="name-0" required value="{{$category->name}}">
                                    </div>
                                </div>
                                <div class="mb-3 row">
                                    <label for="slug" class="col-md-2 col-form-label">Slug</label>
                                    <div class="col-md-10">
                                        <input class="form-control" type="text"  name="slug" placeholder="Enter slug Name" id="slug"value="{{$category->slug}}">
                                    </div>
                                </div>
                                <div class="mb-3 row">
                                    <label for="image" class="col-md-2 col-form-label">Category Image</label>
                                    <div class="col-md-10">
                                        <input class="form-control" type="file"  name="image" placeholder="Categories Logo" id="image">
                                    </div>
                                </div>
                                <div class="mb-3 row">
                                    <label for="image_code" class="col-md-2 col-form-label">Image Code</label>
                                    <div class="col-md-10">
                                        <input class="form-control" type="text"  name="image_code" placeholder="image code" id="image_code"value="{{$category->image_code}}">
                                    </div>
                                </div>
                                <div class="mb-3 row">
                                    <label for="answer-0" class="col-md-2 col-form-label">Select Parent Category</label>
                                    <div class="col-md-10">
                                        <select class="form-control" name="parent_category">
                                            <option value="0">Parent Category</option>
                                            @foreach($pcategory as $value)
                                            <option value="{{$value->id}}" {{$value->id==$category->parent_category?'selected':''}}>{{$value->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="mb-3 row">
                                <label for="meta_title-0" class="col-md-2 col-form-label">Meta title<span class="text-danger">*</span></label>
                                <div class="col-md-10">
                                    <textarea class="form-control" id="meta_title-0" name="course_metatitle"required placeholder="Enter Meta Title">{{$category->course_metatitle}}</textarea>
                                </div>
                            </div>
                            <div class="mb-3 row">
                                <label for="course_meta_keyword-0" class="col-md-2 col-form-label">Meta Keywords<span class="text-danger">*</span></label>
                                <div class="col-md-10">
                                    <textarea class="form-control" id="course_meta_keyword-0" name="course_meta_keyword"required placeholder="Enter Meta Keywords">{{$category->course_meta_keyword}}</textarea>
                                </div>
                            </div>
                            <div class="mb-3 row">
                                <label for="course_meta_description-0" class="col-md-2 col-form-label">Meta Description<span class="text-danger">*</span></label>
                                <div class="col-md-10">
                                    <textarea class="form-control" id="course_meta_description-0" name="course_meta_description"required placeholder="Enter Meta Description">{{$category->course_meta_description}}</textarea>
                                </div>
                            </div>
                            <div class="mb-3 row">
                                <label for="course_meta_description-0" class="col-md-2 col-form-label">Status<span class="text-danger">*</span></label>
                                <div class="col-md-10">
                                    <select name="status" id="status" class="form-control">
                                        <option " value="1"{{$category->status==1?'selected':''}}>Publish</option>
                                        <option  value="0"{{$category->status==0?'selected':''}}>Draft</option>
                                    </select>
                                </div>
                            </div>
                         
                            </div>
                            <div class="mb-3 row">
                                <label for="example-tel-input" class="col-md-2 col-form-label"></label>
                                <div class="col-md-10">
                                    {{-- <button type="button" class="btn btn-primary" onClick="add_faq()" >+Add More</button> --}}
                                    <button type="sumbit" class="btn btn-success">Submit</button>
                                </div>
                            </div>
                        </div>
                        
                    </div>
                </form>
         </div>
    </div>

   

</div>
<!-- // END header-layout__content -->
@endsection

@push('script')
<!-- Include your JavaScript code here -->
@endpush
