@extends('layouts.Master')
@section('page')

   <!-- Header Layout Content -->
   <div class="mdk-header-layout__content mdk-header-layout__content--fullbleed mdk-header-layout__content--scrollable page" style="padding-top: 60px;">


    <div class="page__heading border-bottom">
        <div class="container-fluid page__container d-flex align-items-center">
            <h1 class="mb-0">{{$page_title}}</h1>
        </div>
        <p class="text-success ml-4">{{Session::get('message')?Session::get('message'):''}}</p>
    </div>

    <div class="container-fluid page__container">
        

        <form method="post" enctype="multipart/form-data" action="{{route('profile.update',$result->id)}}">
            @method('PUT')
            @csrf

            <div class="card card-form">
                <div class="row no-gutters">
                    <div class="col-lg-4 card-body">
                        <p><strong class="headings-color">Basic Information</strong></p>
                        <p class="text-muted mb-0">Edit your account details and settings.</p>
                    </div>
                    <div class="col-lg-8 card-form__body card-body">
                        <div class="row">
                            <div class="col">
                                <div class="form-group">
                                    <label for="fname">First name</label>
                                    <input id="fname" name="fname" type="text" class="form-control" placeholder="First name" value="{{$result->fname?$result->fname:''}}">
                                    <input id="id" name="id" type="hidden" class="form-control" value="{{$result->id?$result->id:''}}">
                                    <input id="user_id" name="user_id" type="hidden" class="form-control" value="{{$result->id?$result->user_id:''}}">
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-group">
                                    <label for="lname">Last name</label>
                                    <input id="lname" name="lname" type="text" class="form-control" placeholder="Last name" value="{{$result->lname?$result->lname:''}}">
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-group">
                                    <label for="phone">Phone</label>
                                    <input id="phone" name="phone" type="text" class="form-control" placeholder="Phone" value="{{$result->phone?$result->phone:''}}">
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="desc">Bio / Description</label>
                            <textarea id="desc" name="description_bio" rows="4" class="form-control" placeholder="Bio / description ...">{{$result->description_bio?$result->description_bio:''}}</textarea>
                        </div>
                        <div class="form-group">
                            <label for="country">Country</label><br />
                            <select id="country" name="country" class="custom-select w-auto">
                                @foreach($country as $key=>$value)
                                <option value="{{$key}}" {{$result->country==$value?'selected':''}}>{{$value}}</option>
                                @endforeach
                            </select>
                            
                        </div>
                        <div class="form-group">
                            <label for="subscribe">Subscribe to newsletter</label><br>
                            <div class="custom-control custom-checkbox-toggle custom-control-inline mr-1">
                                <input checked="{{$result->subscribe_to_newsletter?'checked':''}}" name="subscribe_to_newsletter" type="checkbox" id="subscribe" class="custom-control-input">
                                <label class="custom-control-label" for="subscribe">Yes</label>
                            </div>
                            <label for="subscribe" class="mb-0">Yes</label>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card card-form">
                <div class="row no-gutters">
                    <div class="col-lg-4 card-body">
                        <p><strong class="headings-color">Update Your Password</strong></p>
                        <p class="text-muted mb-0">Change your password.</p>
                    </div>
                    <div class="col-lg-8 card-form__body card-body">
                        <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="opass">Old Password</label>
                                        <input id="opass" type="password"  name="opassword"class="form-control" placeholder="Old password" value="****">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="npass">New Password</label>
                                        <input id="npass" type="password" name="npassword" class="form-control is-invalid">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="cpass">Confirm Password</label>
                                        <input id="cpass" type="password" name="cpassword" class="form-control" placeholder="Confirm password">
                                    </div>
                                </div>
                        </div>
                        </div>
                    </div>
                </div>

            <div class="card card-form">
                <div class="row no-gutters">
                    <div class="col-lg-4 card-body">
                        <p><strong class="headings-color">Profile Settings</strong></p>
                        <p class="text-muted mb-0">Update your public profile with relevant and meaningful information.</p>
                    </div>
                    <div class="col-lg-8 card-form__body card-body">
                        <div class="form-group">
                            <label>Profile Image</label>
                                <div class="media-body">
                                    <INPUT type="file"NAME="image">
                                </div>
                        </div>
                        <div class="form-group">
                            <label for="desc2">Description</label>
                            <textarea id="desc2" rows="4" class="form-control" name="description" placeholder="Description ...">{{$result->description?$result->description:''}}</textarea>
                        </div>
                        <div class="form-group">
                            <label for="social1">Social links</label>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="input-group input-group-merge mb-2">
                                        <input id="social1" type="text" class="form-control form-control-prepended" placeholder="Facebook" name="social_link_1" value="{{$result->social_link_1?$result->social_link_1:''}}">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">
                                                <span class="fab fa-facebook text-facebook"></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="input-group input-group-merge mb-2">
                                        <input id="social2" type="text" class="form-control form-control-prepended" placeholder="Twitter" name="social_link_2value="{{$result->social_2ink_1?$result->social_link_1:''}}"">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">
                                                <span class="fab fa-twitter text-twitter"></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="input-group input-group-merge mb-2">
                                        <input id="social3" type="text" class="form-control form-control-prepended" placeholder="Instagram" name="social_link_3"value="{{$result->social_link_3?$result->social_link_1:''}}">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">
                                                <span class="fab fa-instagram text-instagram"></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                </div>
                            </div>
                        </div>
                        
                    </div>
                </div>
                <div class="text-left mb-5">
                    <input type="submit" class="btn btn-success" value="Update">
                </div>
            </div>
        </form>
    </div>
<!-- // END header-layout__content -->

@endsection