@php
  $course_header=App\Models\Course::where('status',1)->orderBy('id','DESC')->paginate(10);   
@endphp
<!-- Start Header Top 
    ============================================= -->
    <div class="top-bar-area bg-dark text-light inline inc-border">
        <div class="container">
            <div class="row align-center">
                
                <div class="col-lg-7 col-md-12 left-info">
                    <div class="item-flex">
                        <ul class="list">
                            <li>
                                <i class="fas fa-phone"></i> Have any question? +91 9711900776
                            </li>
                            <li>
                                <i class="fas fa-bullhorn"></i> <a href="#">Become an Instructor</a>
                            </li>
                        </ul>
                    </div>
                </div>

                <div class="col-lg-5 col-md-12 right-info">
                    <div class="item-flex">
                        <div class="social">
                            <ul>
                                <li>
                                    <a href="#"><i class="fab fa-facebook-f"></i></a>
                                </li>
                                <li>
                                    <a href="#"><i class="fab fa-twitter"></i></a>
                                </li>
                                <li>
                                    <a href="#"><i class="fab fa-pinterest-p"></i></a>
                                </li>
                                <li>
                                    <a href="#"><i class="fab fa-linkedin-in"></i></a>
                                </li>
                            </ul>
                        </div>
                        <div class="button">
                            <a href="{{route('student-registration')}}">Register</a>
                            <a href="{{route('student-login')}}"><i class="fa fa-sign-in-alt"></i> Student Login</a>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <!-- End Header Top -->

    <!-- Header 
    ============================================= -->
    <header id="home">

        <!-- Start Navigation -->
        <nav class="navbar shadow-less navbar-default navbar-sticky bootsnav">

            <div class="container">

                <!-- Start Atribute Navigation -->
                <div class="attr-nav">
                    <form action="#">
                        <input type="text" placeholder="Search" class="form-control" name="text">
                        <button type="submit">
                            <i class="fa fa-search"></i>
                        </button>  
                    </form>
                </div>        
                <!-- End Atribute Navigation -->

                <!-- Start Header Navigation -->
                <div class="navbar-header">
                    <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#navbar-menu">
                        <i class="fa fa-bars"></i>
                    </button>
                    <a class="navbar-brand" href="index.html">
                        <img src="{{url('/')}}/frontend/assets/img/logo.png" class="logo" alt="Logo">
                    </a>
                </div>
                <!-- End Header Navigation -->

                <!-- Collect the nav links, forms, and other content for toggling -->
                <div class="collapse navbar-collapse" id="navbar-menu">
                    <ul class="nav navbar-nav navbar-right" data-in="fadeInDown" data-out="fadeOutUp">
                        <li class="dropdown">
                            <a href="{{url('/')}}" class="dropdown-toggle active" data-toggle="dropdown" >Home</a>
                            <ul class="dropdown-menu">
                    
                            </ul>
                      </li>
                        <li>
                            <a href="{{url('about-us')}}" class="dropdown-toggle" data-toggle="dropdown" >About Us</a> 
      
                        </li>
                        <li class="dropdown">
                            <a href="{{url('courses')}}" class="dropdown-toggle">Courses</a>
                            @if(count($course_header)>0)
                           <ul class="dropdown-menu">
                                @foreach($course_header as $key=>$value)
                                    @if($key<5)
                                        <li><a href="{{url('courses-details/'.$value->course_slug)}}">{{$value->course_title}}</a></li>
                                    @else
                                    <li><a href="{{url('/courses')}}">View More</a></li>
                                    
                                    @endif
                                @endforeach
                                
                            </ul> 
                            @endif
                        </li>
                        <li>
                            <a href="{{url('teachers')}}" class="dropdown-toggle">Teachers</a>
                     
                        </li>
                        <li>
                            <a href="{{url('/blog')}}" class="dropdown-toggle">Blog</a>
                        
                        </li> 
                        <li>
                            <a href="{{url('contact-us')}}">Contact</a>
                        </li> 
                    </ul>
                </div><!-- /.navbar-collapse -->
            </div>

        </nav>
        <!-- End Navigation -->

    </header>
    <!-- End Header -->