<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\CourseController;
use App\Http\Controllers\HrController;
use App\Http\Controllers\MentorController;
use App\Http\Controllers\StaticContentController;
use App\Http\Controllers\StudentController;
use App\Http\Controllers\TeacherController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\ProfileSettingsController;

use App\Http\Controllers\NoticeController;
use App\Http\Controllers\HolidaysController;
use App\Http\Controllers\EventController;
use App\Http\Controllers\DepartmentController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and assigned to the
| "web" middleware group. Make something great!
|
*/

// Public Routes
Route::get('/', [HomeController::class, 'index']);
Route::get('about-us', [HomeController::class, 'AboutUs']);
Route::get('contact-us', [HomeController::class, 'ContactUs']);
Route::get('teachers', [HomeController::class, 'Teachers']);
Route::get('courses', [HomeController::class, 'Courses']);
Route::get('courses-details/{id}', [HomeController::class, 'CoursesDetails']);
Route::get('blog', [HomeController::class, 'Blog']);
Route::get('blog-details', [HomeController::class, 'BlogDetails']);

// Authentication Routes
Route::get('student-login', [AuthController::class, 'studentLogin'])->name('student-login');
Route::get('student-registration', [AuthController::class, 'studentRegistration'])->name('student-registration');
Route::get('login', [AuthController::class, 'login'])->name('login');
Route::get('login_message', [AuthController::class, 'login_message'])->name('login_message');
Route::post('login', [AuthController::class, 'AuthLogin']);
Route::get('logout', [AuthController::class, 'userlogout'])->name('logout');
Route::get('signup', [AuthController::class, 'signup']);
Route::post('signupStore', [AuthController::class, 'signupStore'])->name('signupStore');
Route::get('forget', [AuthController::class, 'forget']);
Route::get('reset_password/{token}', [AuthController::class, 'reset_password']);
Route::get('emailauth', [AuthController::class, 'VerifyEmail']);
Route::post('password_update', [AuthController::class, 'password_update'])->name('password_update');
Route::post('forget-password', [AuthController::class, 'forget_post'])->name('forget_password');
Route::get('otp', [AuthController::class, 'otpview'])->name('otp');
Route::get('terms', [AuthController::class, 'terms']);

// Super Admin Routes
Route::prefix('super-admin')->middleware('superadmin')->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'SuperAdmin'])->name('super_admin_dashboard');
    Route::resource('category', CategoryController::class);
    Route::resource('courses', CourseController::class);
    Route::resource('teachers', TeacherController::class);
    Route::resource('blog', BlogController::class);
    Route::resource('staticpage', StaticContentController::class);
    Route::resource('mentor', MentorController::class);
    Route::resource('students', StudentController::class);
    Route::resource('events', EventController::class);
    Route::resource('holidays', HolidaysController::class);
    Route::resource('departments', DepartmentController::class);
    Route::resource('notices', NoticeController::class);


    Route::resource('profile', ProfileSettingsController::class);
});

// Admin Routes
Route::prefix('admin')->middleware('admin')->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'Adminindex'])->name('admin_dashboard');
    // Route::resource('teachers', TeacherController::class);
    // Route::resource('courses', CourseController::class);
    // Route::resource('category', CategoryController::class);
    // Route::resource('blog', BlogController::class);
    // Route::resource('staticpage', StaticContentController::class);
    // Route::resource('mentor', MentorController::class);
    // Route::resource('student', StudentController::class);
});

// Student Routes
Route::prefix('student')->middleware('student')->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'StudentDashboard'])->name('student_dashboard');
    // Route::resource('courses', CourseController::class);
    // Route::resource('student', StudentController::class);
    // Route::resource('profile', ProfileSettingsController::class);
});

// HR Routes
Route::prefix('hr')->middleware('hr')->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'HRDashboard'])->name('hr_dashboard');
    // Route::resource('courses', CourseController::class);
    // Route::resource('student', StudentController::class);
    // Route::resource('profile', ProfileSettingsController::class);
});

// Faculty Dashboard

// HR Routes
Route::prefix('mentor')->middleware('hr')->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'MentorDashboard'])->name('mentor_dashboard');
    // Route::resource('courses', CourseController::class);
    // Route::resource('student', StudentController::class);
    // Route::resource('profile', ProfileSettingsController::class);
});
