@extends('layouts.Master')

@section('page')
 <!-- Header Layout Content -->
 <div class="mdk-header-layout__content mdk-header-layout__content--fullbleed mdk-header-layout__content--scrollable page" style="padding-top: 60px;">


    <div class="page__heading border-bottom">
        <div class="container-fluid page__container">
            <h2>{{$page_title}}</h2>
            
        </div>
        <div class="card card-form">
            <form method="post" enctype="multipart/form-data" action="{{route('courses.store')}}">
           
                @csrf
             <div class="row p-4">
                 <div class="col-md-6 mt-4">
                     <label for="course_language">Language</label>
                    
                     <select class="form-control" name="course_language">
                        @foreach($language_option as $key=>$value)
                        <option value="{{$key}}">{{$value}}</option>
                        @endforeach
                    </select>
                 </div>
                 <div class="col-md-6 mt-4">
                    <label for="course_title">Course Name</label>
                    <input type="text" name="course_title" class="form-control" id="course_title">
                </div>
                 <div class="col-md-6 mt-4">
                     <label for="course_title">Course Category</label>
             
                     <select class="form-control" name="course_category">
                        @foreach($category as $key=>$value)
                        <option value="{{$value->id}}">{{$value->name}}</option>
                        @endforeach
                    </select>
                 </div>
                 <div class="col-md-6 mt-4">
                     <label for="course_description">Course Description</label>
                     <textarea class="form-control" id="course_description" name="course_description"></textarea>
                     
                 </div>
                 <div class="col-md-6 mt-4">
                     <label for="course_curriculum">Course Curriculum</label>
                     <textarea class="form-control" id="course_curriculum" name="course_curriculum"></textarea>
                 </div>
                 <div class="col-md-6 mt-4">
                     <label for="course_advisior">Course Advisior</label>
                     <textarea class="form-control" id="course_advisior" name="course_advisior"></textarea>
                 </div>
                 <div class="col-md-6 mt-4">
                     <label for="course_lecture">Course Lecture</label>
                     <input type="number" min="1"name="course_lecture" class="form-control" id="course_lecture" value="1">
                 </div>
                 <div class="col-md-6 mt-4">
                     <label for="course_duration">Course Duration</label>
                     <input type="text" name="course_duration" class="form-control" id="course_duration" >
                 </div>
                 <div class="col-md-6 mt-4">
                     <label for="course_skill_level">Course Skill Level</label>
                     <input type="text" name="course_skill_level" class="form-control" id="course_skill_level" >
                 </div>
                 <div class="col-md-6 mt-4">
                     <label for="price">Course Price</label>
                     <input type="number" min=0 name="price" class="form-control" id="price" >
                 </div>
                 <div class="col-md-6 mt-4">
                     <label for="after_discount">Course Discounted Price</label>
                     <input type="text" name="after_discount" class="form-control" id="after_discount" >
                 </div>
                 <div class="col-md-6 mt-4">
                     <label for="course_metatitle">Meta Title</label>
                     <input type="text" name="course_metatitle" class="form-control" id="course_metatitle" >
                 </div>
                 <div class="col-md-6 mt-4">
                     <label for="course_meta_keyword">Meta Keywords</label>
                     <input type="text" name="course_meta_keyword" class="form-control" id="course_meta_keyword" >
                 </div>
                 <div class="col-md-6 mt-4">
                     <label for="course_meta_description">Meta Description</label>
                     <input type="text" name="course_meta_description" class="form-control" id="course_meta_description" >
                 </div>
                 <div class="col-md-6 mt-4">
                    <label for="status">Status</label>
                       <select name="status" id="status" class="form-control">
                        <option " value="1">Publish</option>
                        <option  value="0">Draft</option>
                    </select>
                </div>
                 <div class="col-md-6 mt-4">
                    <label for="course_media">Course Image</label>
                        <input class="form-control" type="file"  name="course_media" placeholder="Categories Logo" id="course_media">
                </div>
                 
                 
             </div>
             <div class="p-4">
                 <button type="submit" class="btn btn-primary">Submit</button>
             </div>
             </form>
         </div>
    </div>

    {{-- <div class="container-fluid page__container">
       

    </div> --}}


</div>
<!-- // END header-layout__content -->
@endsection

@push('script')
<!-- Include your JavaScript code here -->
@endpush
