@extends('layouts.Master')
@section('page')

   <!-- Header Layout Content -->
   <div class="mdk-header-layout__content mdk-header-layout__content--fullbleed mdk-header-layout__content--scrollable page" style="padding-top: 60px;">


    <div class="page__heading border-bottom">
        <div class="container-fluid page__container d-flex align-items-center">
            <h1 class="mb-0">{{$page_title}}</h1>
        </div>
        <p class="text-success ml-4">{{Session::get('message')?Session::get('message'):''}}</p>
    </div>

    <div class="container-fluid page__container">
        

        <form method="post" enctype="multipart/form-data" action="{{route('students.update',$student->id)}}">
            @csrf
            @method('PUT')

            <div class="card card-form">
                <div class="row no-gutters">
                 
                    <div class="col-lg-12 card-form__body card-body">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="reg_no">Registration Number</label>
                                    <input id="reg_no" name="reg_no" type="text" value="{{$student->reg_no}}" class="form-control" placeholder="Registration Number">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="batch_id">Batch</label>
                                    <input id="batch_id" name="batch_id" type="number" value="{{$student->batch_id}}" class="form-control" placeholder="Batch">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="admission_date">Admission Date</label>
                                    <input id="admission_date" name="admission_date" type="date" value="{{$student->admission_date}}" class="form-control" placeholder="Admission Date">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="student_name">Student Name</label>
                                    <input id="student_name" name="student_name" type="text" value="{{$student->student_name}}" class="form-control" placeholder="Student Name">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="student_address">Student Address</label>
                                    <input id="student_address" name="student_address" type="text" value="{{$student->student_address}}" class="form-control" placeholder="Last name">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="phone">Phone</label>
                                    <input id="phone" name="phone" type="text" value="{{$student->phone}}" class="form-control" placeholder="Phone">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="dob">DOB</label>
                                    <input id="dob" name="dob" value="{{$student->dob}}" type="date" class="form-control" placeholder="DOB">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="Email">Email</label>
                                    <input id="Email" name="email" value="{{$student->email}}" type="email" class="form-control" placeholder="Email">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="father_name">Father Name</label>
                                    <input id="father_name" name="father_name" type="text" value="{{$student->father_name}}" class="form-control" placeholder="Father Name">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="father_phone">Father Phone</label>
                                    <input id="father_phone" name="father_phone" type="text" value="{{$student->father_phone}}" class="form-control" placeholder="Father Phone">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="mother_name">Mother Name</label>
                                    <input id="mother_name" name="mother_name" type="text" value="{{$student->mother_name}}" class="form-control" placeholder="Mother Name">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="mother_phone">Mother Phone</label>
                                    <input id="mother_phone" name="mother_phone" type="text" value="{{$student->mother_phone}}" class="form-control" placeholder="Mother Phone">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="resident_phone">Resident Phone</label>
                                    <input id="resident_phone" name="resident_phone" type="text" value="{{$student->resident_phone}}" class="form-control" placeholder="Resident Phone">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="resident_address">Resident Address</label>
                                    <input id="resident_address" name="resident_address" type="text" value="{{$student->resident_address}}" class="form-control" placeholder="Resident Address">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="admitted_by">Addmitted By</label>
                                    <input id="admitted_by" name="admitted_by" type="text" value="{{$student->admitted_by}}" class="form-control" placeholder="Addmitted By">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="admitted_by">Select Programme</label>
                                  
                                    <select name="enroll_programme" id="enroll_programme"class="form-control">
                                        @foreach($course as $key=>$value)
                                    <option value="{{$value->course_title}}" {{$student->enroll_programme=$value->course_title?'selected':''}}>{{$value->course_title}}</option>
                                    @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="admitted_by">Image</label>
                                    <input type="file" name="image" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="admitted_by">Status</label>
                                    <select name="status" id="status"class="form-control">
                                        <option value="1">Publish</option>
                                        <option value="0">Draft</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <button type="submit" class="form-control mt-4 btn btn-success">Submit</button>
                            </div>
                        </div>
                        
                    </div>
                </div>
            </div>
        </div>

            
        </form>
    </div>
<!-- // END header-layout__content -->

@endsection