@extends('layouts.FrontLayout')
@section('page')
    
    <!-- Start Breadcrumb 
    ============================================= -->
    <div class="breadcrumb-area bg-gray text-center shadow dark text-light bg-cover" style="background-image: url({{url('/')}}/frontend/assets/img/teachers.png);">
        <div class="container">
            <div class="row">
                <div class="col-lg-8 offset-lg-2">
                    <h1>Teachers</h1>
                    <ul class="breadcrumb">
                        <li><a href="{{url('/')}}"><i class="fas fa-home"></i> Home</a></li>
                        <li class="active">Teachers</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- End Breadcrumb -->

    <!-- Star Advisor Area
    ============================================= -->
    <div class="advisor-area default-padding bottom-less">
        <div class="container">
            <div class="advisor-items text-center">
                <div class="row">
                    @if(count($teacher)>0)
                        @foreach ($teacher as $key=>$value)
                        <!-- Single Item -->
                        <div class="single-item col-lg-3 col-md-6">
                            <div class="item">
                                <div class="thumb">
                                    <img src="{{url('/images/'.$value->image)}}" alt="{{$value->name}}">
                                    <ul>
                                        <li class="facebook">
                                            <a href="{{$value->social_link_1}}">
                                                <i class="fab fa-facebook-f"></i>
                                            </a>
                                        </li>
                                        <li class="twitter">
                                            <a href="{{$value->social_link_2}}">
                                                <i class="fab fa-twitter"></i>
                                            </a>
                                        </li>
                                        <li class="linkedin">
                                            <a href="{{$value->social_link_3}}">
                                                <i class="fab fa-linkedin-in"></i>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                                <div class="info">
                                    <h4><a href="#">{{$value->name}}</a></h4>
                                    <span>{{$value->designation}}</span>
                                </div>
                            </div>
                        </div>
                        <!-- End Single Item -->
                        @endforeach
                    @else
                    <h1> No Teacher Data Found</h1>
                    @endif


                </div>
            </div>
        </div>
    </div>
    <!-- End Advisor Area -->
@endsection